/*=========================================================

	cdialog/message.h

	bZ[W_CAOB

=========================================================*/
#ifndef CDIALOG_MESSAGE_H
#define CDIALOG_MESSAGE_H

#include "dev.h"

/*=========================================================
	萔
=========================================================*/
#define CDIALOG_MESSAGE_TITLE_LENGTH 32
#define CDIALOG_MESSAGE_LENGTH       512

#ifdef __cplusplus
extern "C" {
#endif

/*=========================================================
	^錾
=========================================================*/
typedef enum {
	CDIALOG_MESSAGE_YESNO = 0x00000001,
} CdialogMessageOptions;

typedef int ( *CdialogMessageCallback )( unsigned short x, unsigned short y, struct cdialog_dev_color *colors );

typedef struct {
	char title[CDIALOG_MESSAGE_TITLE_LENGTH];
	unsigned int options;
	char message[CDIALOG_MESSAGE_LENGTH];
	
	unsigned int width, height;
	CdialogMessageCallback callback;
} CdialogMessageData;

typedef struct {
	bool destroySelf;
	struct cdialog_dev_base_params base;
	CdialogMessageData data;
} CdialogMessageParams;

/*=========================================================
	֐
=========================================================*/
int cdialogMessageInit( CdialogMessageParams *params );
CdialogMessageData *cdialogMessageGetData( void );
CdialogStatus cdialogMessageGetStatus( void );
CdialogResult cdialogMessageGetResult( void );
int cdialogMessageStart( unsigned short x, unsigned short y );
int cdialogMessageStartNoLock( unsigned short x, unsigned short y );
int cdialogMessageUpdate( void );
int cdialogMessageShutdownStartNoLock( void );
int cdialogMessageShutdownStart( void );
void cdialogMessageDestroy( void );

#ifdef __cplusplus
}
#endif

#endif
